# -*- coding: utf-8 -*-

# copywarning.py
# This file is part of qarte-5
#    
# Author: Vincent Vande Vyvre <vincent.vandevyvre@oqapy.eu>
# Copyright: 2022 Vincent Vande Vyvre
# Licence: GPL3
# Home page: https://launchpad.net/qarte
#
# Warning message box for vidéo's file name

from PyQt5.QtCore import QSize
from PyQt5.QtGui import QIcon, QPixmap
from PyQt5.QtWidgets import (QGridLayout, QVBoxLayout, QHBoxLayout, QLabel, 
                             QSpacerItem, QSizePolicy, QLineEdit, QPushButton,
                             QDialog)

class CopyWarning(QDialog):
    def __init__(self, fname, caller):
        super().__init__(parent=caller.ui)
        self.setWindowTitle(_("Copy Error"))
        self.fname = fname
        self.caller = caller
        self.resize(382, 153)
        self.gridLayout = QGridLayout(self)
        self.verticalLayout = QVBoxLayout()
        self.horizontalLayout = QHBoxLayout()
        self.warn_lbl = QLabel(self)
        self.warn_lbl.setText(_("The file name seems not accepted."))
        self.horizontalLayout.addWidget(self.warn_lbl)
        sp = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout.addItem(sp)
        self.verticalLayout.addLayout(self.horizontalLayout)
        self.horizontalLayout_2 = QHBoxLayout()
        self.warn_2_lbl = QLabel(self)
        self.warn_2_lbl.setText(_("Please, enter a new name:"))
        self.horizontalLayout_2.addWidget(self.warn_2_lbl)
        sp1 = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout_2.addItem(sp1)
        self.verticalLayout.addLayout(self.horizontalLayout_2)
        self.fname_led = QLineEdit(self)
        self.fname_led.setMinimumSize(QSize(350, 0))
        self.verticalLayout.addWidget(self.fname_led)
        self.horizontalLayout_3 = QHBoxLayout()
        spa2 = QSpacerItem(40, 20, QSizePolicy.Expanding, QSizePolicy.Minimum)
        self.horizontalLayout_3.addItem(spa2)
        self.ok_btn = QPushButton(self)
        self.ok_btn.setText("OK")
        icon = QIcon()
        icon.addPixmap(QPixmap("/medias/apply.png"), QIcon.Normal, QIcon.Off)
        self.ok_btn.setIcon(icon)
        self.horizontalLayout_3.addWidget(self.ok_btn)
        self.verticalLayout.addLayout(self.horizontalLayout_3)
        self.gridLayout.addLayout(self.verticalLayout, 0, 0, 1, 1)

        self.ok_btn.setEnabled(False)
        self.ok_btn.clicked.connect(self.on_exit)
        self.fname_led.setText(fname)
        self.fname_led.textChanged.connect(self.on_text_edited)

    def on_text_edited(self, text):
        self.ok_btn.setEnabled(self.fname != text)

    def on_exit(self):
        self.caller.new_name = self.fname_led.text()
        self.accept()








